<?php

class Ultimate_AI_License{
    public $baseURL = 'https://ultimateai.io/wp-json/license/v1';
    public function activate_licence( $key ){
        try{
            $response = wp_remote_get( $this->baseURL . '/activate/' . $key, array(
                'headers' => array(
                    'referer' => home_url(),
                )
            ) );
            $res_body = json_decode( wp_remote_retrieve_body( $response ) );
            if( !is_null( $res_body ) ){
                if( $res_body->activated ){
                    return $this->ultimate_ai_update_licence($res_body);
                }else{
                    return $res_body;
                }
            }else{
                return [
                    "verified"  => false,
                    "message"   => esc_html__("Activation failed", ULTIMATE_AI_SLUG),
                ];
            }
        }catch( Exception $e ){
            return $e->getMessage();
        }
    }
    public function ultimate_ai_update_licence($data){
		$purchasekey = $data->licence_details[0]->purchase_key;
		$licencekey = $data->licence_details[0]->license_key;
		if( !isset( $purchasekey ) || empty( $purchasekey ) ) {
			return [
                "activated"  => false,
                "message"   => esc_html__("Invalid purchase key", ULTIMATE_AI_SLUG),
            ];
		}
		if( !isset( $licencekey ) || empty( $licencekey ) ) {
			return [
                "activated"  => false,
                "message"   => esc_html__("Invalid licence key.", ULTIMATE_AI_SLUG),
            ];
		}
		$purchasekeyupdated = update_option( 'uai_activation_key', $purchasekey);
		$licencekeyupdated = update_option( 'uai_licence_key', $licencekey);
		
		if( $purchasekey && $licencekey ){
			return [
				"message" => esc_html__("Successfully updated", ULTIMATE_AI_SLUG),
				"updated" => true,
				"activated" => true,
                "data" => $data
			];
		}
	}
    public function deactivate_licence( $purchasekey, $licencekey ){
        try{
            $response = wp_remote_get( $this->baseURL . '/deactivate/' . $purchasekey . '/' . $licencekey, array(
                'headers' => array(
                    'referer' => home_url(),
                )
            )  );
            $res_body = json_decode( wp_remote_retrieve_body( $response ) );
            return $res_body;
        }catch( Exception $e ){
            return $e->getMessage();
        }
    }
    public function verify_licence( $purchasekey, $licencekey ){
        try{
            $response = wp_remote_get( $this->baseURL . '/verify/' . $purchasekey . '/' . $licencekey );
            $res_body = json_decode( wp_remote_retrieve_body( $response ) );
            return $res_body;
        }catch( Exception $e ){
            return $e->getMessage();
        }
    }
}